/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.monitor.model;

import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.monitor.monitor.model.IconType;
import com.tp_link.eap.monitor.monitor.model.MapApDetail;

public class MapAp {
    private boolean located;
    private String label;
    private MapApDetail details;
    private Double startX;
    private Double startY;
    private Double coverage;
    private boolean showAlert;
    private boolean locked;
    private Integer status;
    private String iconType;

    public boolean isLocated() {
        return this.located;
    }

    public void setLocated(boolean located) {
        this.located = located;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public MapApDetail getDetails() {
        return this.details;
    }

    public void setDetails(MapApDetail details) {
        this.details = details;
    }

    public Double getStartX() {
        return this.startX;
    }

    public void setStartX(Double startX) {
        this.startX = startX;
    }

    public Double getStartY() {
        return this.startY;
    }

    public void setStartY(Double startY) {
        this.startY = startY;
    }

    public boolean isShowAlert() {
        return this.showAlert;
    }

    public void setShowAlert(boolean showAlert) {
        this.showAlert = showAlert;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public Double getCoverage() {
        return this.coverage;
    }

    public void setCoverage(Double coverage) {
        this.coverage = coverage;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getIconType() {
        return this.iconType;
    }

    public void setIconType(String iconType) {
        this.iconType = iconType;
    }

    public MapAp() {
    }

    public MapAp(boolean located, boolean showAlert, boolean locked, MapApDetail details, Double startX, Double startY, Double coverage) {
        this.label = details.getName();
        this.located = located;
        this.showAlert = showAlert;
        this.details = details;
        this.startX = startX;
        this.startY = startY;
        this.coverage = coverage;
    }

    public MapAp(Ap ap, MapApDetail details, boolean isAdopt) {
        this.details = details;
        this.label = ap.getName();
        this.located = ap.getLocation().isLocated();
        this.locked = ap.getLocation().isLocked();
        this.startX = ap.getLocation().getPosX();
        this.startY = ap.getLocation().getPosY();
        this.status = ap.getStatus();
        if (isAdopt) {
            this.showAlert = ap.getStatus() == 0;
            this.coverage = ap.getCoverage();
        } else {
            this.showAlert = false;
            this.coverage = 0.0;
        }
        this.iconType = this.getIcon(ap.getModel(), ap.getModelVersion());
    }

    private String getIcon(String model, String modelVersion) {
        return IconType.getIcon(model, modelVersion);
    }
}

